	% Example 9.7 Constraind IIR
	clear all, close all, clc
	Ts = [1 1 1 1 1 1];	%	Fixed polynomial for the zeros (all is the stopband)
	Tp = [1];			%	Fixed polynomial for the poles
	Ts = sum(Tp)*Ts/sum(Ts);	% Normalize Hfix = Ts/Tp to 1 at wT = 0
	Dratio = 10.87;		%	Desired ripple ratio 	
	Ndecim = 1;	
	wcT = 0.2*pi; wsT = 0.3*pi;
	N = 6;	M = 4;
	[G, Z, P, dc, ds] = CONSTRAINED_LP_IIR(N, M, Ts, Tp, wcT, wsT, Dratio)
	% dc, ds for the designed filter
	subplot(2,1,1)
	wT = linspace(0,pi,1000);  
	H0 = PZ_2_FREQ_Z(G, Z, P, wT);	
	PLOT_MAG_Z_dB(wT, H0, pi, 100, '-'),	hold on
	Hfix = freqz(Ts,Tp,wT);
	PLOT_MAG_Z_dB(wT, Hfix, pi, 100, 'H'),	zoom on	
	subplot(2,1,2) 
	Htot = H0.*Hfix;
	PLOT_MAG_Z_dB(wT,Htot, pi, 100, 'H'),	zoom on						
% 
